#ifndef __CAssert__
#define __CAssert__

//	===========================================================================

#include <assert.h>

//	===========================================================================

namespace Exponent
{
	namespace Testing
	{
		/**
		 * @class CAssert CAssert.hpp
		 * @brief Provides debugging assert support
		 *
		 * @date 18/08/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CAssert.hpp,v 1.2 2007/02/08 21:06:44 paul Exp $
		 */
		class CAssert
		{
		public:

//	===========================================================================

			/**
			 * Assert that a value is false
			 */
			static void assertFalse() { assert(false); }

			/**
			 * Assert that a value is true
			 */
			static void assertTrue() { assert(true); }

			/**
			 * Assert that a value is >= 0.0 && <= 1.0
			 * @param value Value to check
			 */
			static void assertNormalisedSignalRange(const double value) { assert(value >= 0.0 && value <= 1.0); }

			/**
			 * Assert that a value is non null
			 * @param value Pointer to check
			 */
			static void assertNotNull(const void *value) { assert(value != NULL); }

//	===========================================================================

		};
	}
}
#endif	// End of CAssert.hpp